<?php

namespace  Bids;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Bids extends Model 
{

    protected $table = 'bids';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->hasOne('Users_Details');
    }

    public function supply_agreement_logs()
    {
        return $this->hasMany('Supply_Agreement_Logs', 'id', 'fk_bids_id');
    }

    public function consolidated_demands()
    {
        return $this->hasOne('Consolidated_Demands', 'fk_consolidated_demands_id', 'id');
    }

    public function batch_bids()
    {
        return $this->hasOne('Batch_Bids', 'fk_batch_bids_id', 'id');
    }

}